package OOPLS;

import java.util.Iterator;

public class PointList2 {
    static class node {
        Point p;
        node link;
        public node(Point p) { this.p = p; }
        public node(Point p, node link) {
            this.p = p; this.link = link;
        }
    }
    node front, back;
    public void push_front(Point p) {
        if (front == null) front = back = new node(p);
        else {
            front = new node(p,front);
        }
    }
    public void push_back(Point p) {
        if (front == null) push_front(p);
        else {
            back = back.link = new node(p);
        }
    }
    public Point getFront() {
        if (front == null) return null;
        else return front.p;
    }
    public Point getBack() {
        if (back == null) return null;
        else return back.p;
    }    
    public Iterator<Point> iterator() {
        return new Iterator<Point>() {
            node last, current;
            { last = current = front; }
            public boolean hasNext() { return current != null; }
            public Point next() {
                Point rv = current.p;
                last = current;
                current = current.link;
                return rv;
            }
            public void remove() {
                if (current != null) {
                    if (current == front) {
                        front = last = current = current.link;
                        if (front == null) back = null;
                    }
                    else last.link = current = current.link;
                }
            }
        }; // Note semi-colon.  This ends the return statement!
    }
  
}
